function R=FindBestRigidRotation(A,B,method)
    % Find R = Argmin (R*A-B)^2
    %
    % method may be 'Arun' or 'Horn'  Current default is 'Horn'
    %
    % 
    % Copyright (C) Russell H. Taylor 2013
    % For use with CIS I only
    % Do not redistribute without written permission from Russell Taylor
   
    if nargin>2
        m = method;
    else
        m = 'Arun'; % Horn's method seems to be having troubles with MSTLAB eigs routine
    end
    if isa(A,'RotMx')
        AA=[]; BB=[];
        for i=1:size(A,1)
            for j=1:size(A,2)
                AA=[AA,A(i,j).el];
                BB=[BB,B(i,j).el];
            end
        end
        R = FindBestRigidRotation(vct3Array(AA),vct3Array(BB),m);
        return;
    end
    
    switch m
        case 'Arun'
            H = A.el*B.el';
            [U,S,V] =svd(H);
            Rel = V*U';
            d = det(Rel);
            if d<=0 
                s = diag(S);
                s = s/norm(s);
                if any(s<1.0e-4)
                    V =[V(:,1),V(:,2),-V(:,3)];
                    Rel=V*U';
                else
                    error('Arun method case not handled yet, det=-1 and all singular values non-zero');
                end
                
            end
            R = RotMx(Rel);
        case 'Horn'
            H = A.el*B.el';
            t = trace(H);
            Delta = [H(2,3)-H(3,2), H(3,1)-H(1,3), H(1,2)-H(2,1)];
            HH = H+H'-t*eye(3);
            G = [ [ t,       Delta];   ...
                  [ Delta(1),HH(1,:)]; ...
                  [ Delta(2),HH(2,:)]; ...
                  [ Delta(3),HH(3,:)]];
            [V,D] = eigs(G,1); % MATLAB sometimes gets this confused if
                               % matrix is almost unit.
                                 
            R = RotMx(quaternion(V(2),V(3),V(4),V(1)));
        case 'QuatSVD'  % still debugging
            R = RotAXXB(B,A);
        otherwise
            error('unknown method for find best rigid rotation');
    end

end
